<?php
/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class OtpprestaRedirectModuleFrontController extends ModuleFrontController
{
    /**
     * Do whatever you have to before redirecting the customer on the website of your payment processor.
     */
    public function postProcess()
    {
        /*
         * Oops, an error occured.
         */
        if (Tools::getValue('action') == 'error') {
        	return $this->displayError('An error occurred while trying to redirect the customer');
	    } else {
			
			$this->context->smarty->assign("action",Configuration::get("otppresta_form_url",""));
			if(!isset($_POST["hosteddataid"]))
				$this->context->smarty->assign("hosteddataid","");
			
			foreach($_POST as $key => $val){
				if($key == "currency")
					$this->context->smarty->assign("currency_num","{$val}");
				else
					$this->context->smarty->assign("{$key}","{$val}");
			}
			
		    return $this->setTemplate('module:otppresta/views/templates/front/redirect.tpl');
        }
    }

    protected function displayError($message, $description = false)
    {
        $this->context->smarty->assign('errors',["Unknown error"]);
		$this->context->smarty->assign('module_base_url','');
		$this->context->smarty->assign('shop_name','');
		$this->context->smarty->assign('param_link','');
		return $this->setTemplate('module:otppresta/views/templates/front/error.tpl');
    }
}
