<?php
/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class OtpprestaValidationModuleFrontController extends ModuleFrontController
{
    /**
     * This class should be use by your Instant Payment
     * Notification system to validate the order remotely
     */
    public function postProcess()
    {
        /*
         * If the module is not active anymore, no need to process anything.
         */
        

        /**
         * Since it is an example, we choose sample data,
         * You'll have to get the correct values :)
         */
        $cart_id     = $this->context->cart->id;
		
		$is_preauth = false;
		
		if(!$cart_id){
			if(isset($_REQUEST["oid"])){
				$cart_id = substr($_REQUEST["oid"],6);
			}
		}
		
		if(!$cart_id){
			$this->context->smarty->assign([
				'errors'      => [$this->module->l('Bad request')],
				'param_link'  => "index.php",
				'shop_name'   => Configuration::get('PS_SHOP_NAME')
			]);
			$this->context->smarty->assign("module_base_url",$this->module->module_base_url);
			$this->setTemplate('module:otppresta/views/templates/front/error.tpl');
			return;
		}
		
		$order_id = Order::getOrderByCartId((int)($cart_id));
		$secure_key  = Context::getContext()->customer->secure_key;
		
		if($order_id ){
			$txntype = Configuration::get("txntype","");
			if(isset($_REQUEST["txntype"]))
				$txntype = $_REQUEST["txntype"];
			
			$is_preauth = $txntype == "preauth";
			
			$data = $this->module->getTransactionData($order_id, $txntype);
			
			$order = new Order((int)$order_id);
			
			$success = false;
			
			if($data){
				if(isset($data["processor_response_code"])){
					if($data["processor_response_code"] == "00"){
						$success = true;
					}
				}
				if(isset($data["ProcessorResponseCode"])){
					if($data["ProcessorResponseCode"] == "00"){
						$success = true;
					}
				}
			}else{
				$this->context->smarty->assign([
					'errors' => [$this->module->l('Transaction data for order not found!Order ID:') . $order_id],
					'param_link'  => "index.php",
					'shop_name'   => Configuration::get('PS_SHOP_NAME')
				]);
				$this->context->smarty->assign("module_base_url",$this->module->module_base_url);
				$this->setTemplate('module:otppresta/views/templates/front/error.tpl');
				return;
			}
			
			if($success){
				$this->context->smarty->assign([
					'param_title' => $this->getMessageTitle(true, $is_preauth),
					'param_lines' => $this->module->filter_displayable($data, true),
					'param_link'  => 'index.php?controller=order-confirmation&id_cart='.$cart_id.'&id_module='.$this->module->id.'&id_order='. $order_id .'&key='.$secure_key,
					'shop_name'   => Configuration::get('PS_SHOP_NAME')					
				]);
				$this->context->smarty->assign("module_base_url",$this->module->module_base_url);
				$this->setTemplate('module:otppresta/views/templates/front/success.tpl');
			}else{
				$this->context->smarty->assign([
					'param_title' => $this->getMessageTitle(false, $is_preauth),
					'param_lines' => $this->module->filter_displayable($data, true),
					'param_link'  => "index.php?controller=cart&action=show",
					'shop_name'   => Configuration::get('PS_SHOP_NAME')					
				]);
				$this->context->smarty->assign("module_base_url",$this->module->module_base_url);
				$this->setTemplate('module:otppresta/views/templates/front/failed.tpl');
			}
		}else{
			$cart = new Cart((int) $cart_id);
			
			$customer_id = $cart->id_customer;
			$currency_id = $cart->id_currency;
		   
			Context::getContext()->customer = new Customer((int) $customer_id);
			Context::getContext()->currency = new Currency((int) Context::getContext()->cart->id_currency);
			Context::getContext()->language = new Language((int) Context::getContext()->customer->id_lang);
			
			$total       = (float)$cart->getOrderTotal(true, Cart::BOTH);
			$txntype = Configuration::get("txntype","");
			if(isset($_REQUEST["txntype"]))
				$txntype = $_REQUEST["txntype"];
			
			$is_preauth = $txntype == "preauth";
			
			$success = false;
			
			if ($this->isValidOrder() === true) {
				
				if($txntype == "sale"){
					$payment_status = Configuration::get('otppresta_sale_completed');	
				}else if($txntype == "preauth"){
					$payment_status = Configuration::get('otppresta_pre_authorization_completed');	
				}else if($txntype == "void"){
					$payment_status = Configuration::get('otppresta_void_completed');	
				}else
					$payment_status = Configuration::get('PS_OS_PAYMENT');
				
				$message = null;
				$success = true;
				
			} else {
				$payment_status = Configuration::get('otppresta_payment_failed');
				$message = $this->module->l('Payment failed');
			}
			
			//if($is_preauth)
			//	$total = 0.00;
		
			$this->module->validateOrder($cart_id, $payment_status, $total , $this->module->displayName , $message, array(), $currency_id, false, $secure_key);
			
			$order = new Order((int)$this->module->currentOrder);
			
			if(!$success){
				Context::getContext()->cart = $cart;
			}
			
			if(isset($_REQUEST["oid"]))
				$this->module->storeTransactionData($this->module->currentOrder, $txntype , $_REQUEST);
			
			if($success){
				$this->context->smarty->assign([
					'param_title' => $this->getMessageTitle(true, $is_preauth),
					'param_lines' => $this->module->filter_displayable($_REQUEST, true),
					'param_link'  => '',
					'shop_name'   => Configuration::get('PS_SHOP_NAME')
				]);
				
				$this->module->notifyCustomer(
					Context::getContext()->customer->email, 
					$this->getMessageTitle(true, $is_preauth),
				    $this->context->smarty->fetch('module:otppresta/views/templates/front/success.tpl')
				);
				
				$this->context->smarty->assign("param_link",'index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$secure_key);	
				$this->context->smarty->assign("module_base_url",$this->module->module_base_url);
				$this->setTemplate('module:otppresta/views/templates/front/success.tpl');
				
				try{
					Db::getInstance()->execute('UPDATE `' . _DB_PREFIX_ . 'order_payment` SET `transaction_id` = \'' . pSQL($_REQUEST["ipgTransactionId"]) . '\'  WHERE `order_reference` = \'' . pSQL($order->reference) . '\''); 
				}catch(Exception $ex){
					//
				}
				
				if(isset($_POST["hosteddataid"])){
					if($_POST["hosteddataid"]){
						$cuid = $this->module->getCustomerUid(Context::getContext()->customer->email);
						Configuration::updateValue("otppresta_{$cuid}_cof_consent", "yes");
					}else
						Configuration::updateValue("otppresta_{$cuid}_cof_consent", "");
				}else
					Configuration::updateValue("otppresta_{$cuid}_cof_consent", "");
			}else{
				$this->context->smarty->assign([
					'param_title' => $this->getMessageTitle(false, $is_preauth),
					'param_lines' => $this->module->filter_displayable($_REQUEST, true),
					'param_link'  => '',
					'shop_name'   => Configuration::get('PS_SHOP_NAME')
				]);
				
				$this->module->notifyCustomer(
					Context::getContext()->customer->email, 
					$this->getMessageTitle(false, $is_preauth),
				    $this->context->smarty->fetch('module:otppresta/views/templates/front/failed.tpl')
				);
				
				if(isset($_POST["hosteddataid"])){
					if($_POST["hosteddataid"]){
						$cuid = $this->module->getCustomerUid(Context::getContext()->customer->email);
						Configuration::updateValue("otppresta_{$cuid}_cof_consent", "yes");
					}else
						Configuration::updateValue("otppresta_{$cuid}_cof_consent", "");
				}else
					Configuration::updateValue("otppresta_{$cuid}_cof_consent", "");
				
				$this->context->smarty->assign("param_link","index.php?controller=cart&action=show");
				$this->context->smarty->assign("module_base_url",$this->module->module_base_url);
				
				$this->setTemplate('module:otppresta/views/templates/front/failed.tpl');
				try{
					Db::getInstance()->execute('UPDATE `' . _DB_PREFIX_ . 'order_payment` SET `transaction_id` = \'' . pSQL($_REQUEST["ipgTransactionId"]) . '\'  WHERE `order_reference` = \'' . pSQL($order->reference) . '\''); 
				}catch(Exception $ex){
					//
				}
			}
		}
    }
	
	public function getMessageTitle($success, $is_preauth){
		if($success){
			if($is_preauth){
				return $this->module->l('The amount is reserved on your card successfully');
			}else{
				return $this->module->l('The payment completed successfully');
			}
		}else{
			if($is_preauth){
				return $this->module->l('An amount reservation on your card failed');
			}else{
				return $this->module->l('The payment failed');
			}
		}
		
	}

    protected function isValidOrder()
    {
        $success = false;
			
		
		if(isset($_REQUEST["processor_response_code"])){
			if($_REQUEST["processor_response_code"] == "00"){
				$success = true;
			}
		}
		if(isset($_REQUEST["ProcessorResponseCode"])){
			if($_REQUEST["ProcessorResponseCode"] == "00"){
				$success = true;
			}
		}
		
		
		return $success;
    }
}
