<?php
/**
 * OTP payment method for Presta
 * Plugin URI: https://www.otp.rs
 * Description: OTP BANKA, Serbia payment method. Accept Visa, MasterCard, Dina credit cards and OTP voucher payments.
 * Version: 1.0.0
 * Author: Holest Engineering
 * Author URI: https://holest.com 
 * License: GPL2
 * License URI:  https://www.gnu.org/licenses/gpl-2.0.html
 * Owner: OTP BANKA SRBIJA - all rights reserved
 * Created: Belgrade/Serbia, April 2020
 */ 
 
 
$l = $this->l('transactionresult','otppresta');
$l = $this->l('status','otppresta');
$l = $this->l('timezone','otppresta');
$l = $this->l('oid','otppresta');
$l = $this->l('orderid','otppresta');
$l = $this->l('txndatetime','otppresta');
$l = $this->l('transactionid','otppresta');
$l = $this->l('ipgtransactionid','otppresta');
$l = $this->l('endpointtransactionid','otppresta');
$l = $this->l('approval_code','otppresta');
$l = $this->l('approvalcode','otppresta');
$l = $this->l('chargetotal','otppresta');
$l = $this->l('currency','otppresta');
$l = $this->l('processor_response_code','otppresta');
$l = $this->l('processorresponsecode','otppresta'); 

$this->statuses = array();

$statuses = OrderState::getOrderStates((int)$this->context->language->id);
foreach ($statuses as $status) {
	$this->statuses[$status['id_order_state']] = $status['name'];
}
		global $cookie;

$this->_form_fields = array(

		'enabled' => array(
                        'type' => 'select',
                        'label' => $this->l('Enabled','otppresta'),
                        'is_bool' => true,
                        'desc' => $this->l('Enable this payment method','otppresta'),
						'default' => "no",
                        'options' => array(
                            "yes" => $this->l('Enabled','otppresta'),
                            "no"  => $this->l('Disabled','otppresta')
                        )
        ),
		
		'user_sid' => array(
				'label' => $this->l('User SID','otppresta'),
				'type' => 'text',
				'desc' => $this->l('Enter merchant user SID.','otppresta'),
				'default' => '',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter SID','otppresta')
		),
		
		'user_store_sid_different' => array(
				'label' => $this->l('User and Shop SID are different','otppresta'),
				'type' => 'select',
				'desc' => $this->l('Select whether store and user SIDs are same or different','otppresta'),
				'default' => 'no',
				'default' => "no",
				'options' => array(
					"yes" => $this->l('Yes','otppresta'),
					"no"  => $this->l('No','otppresta')
				)
		),
		
		'store_sid' => array(
				'label' => $this->l('Store SID','otppresta'),
				'type' => 'text',
				'desc' => $this->l('Enter merchant store SID.','otppresta'),
				'default' => '',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter SID','otppresta')
		),
		
		'shared_secret' => array(
				'label' => $this->l('Shared secret (form redirect)','otppresta'),
				'type' => 'password',
				'desc' => $this->l('Enter shared secret.','otppresta'),
				'default' => '',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter shared secret','otppresta')
		),
		
		'form_url' => array(
				'label' => $this->l('Payment form submit URL','otppresta'),
				'type' 			=> 'text',
				'desc' => $this->l('Form submit URL for form submit. Put production url for store in production, not test one. (Provided by OTP).','otppresta'),
				'default' => 'https://test-api.ipay.rs/connect/gateway/processing',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter url','otppresta')
		),
		
		'txntype' => array(
			'label'       => $this->l('Payment transaction type','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('Select transaction type','otppresta'),
			'default'     => 'PreAuth',
			'desc_tip'    => true,
			'options'     => array(
			  "sale"      => $this->l('Sale','otppresta'),
			  "preauth"   => $this->l('Pre-Authorization/Capture','otppresta')
			)
		),
		
		'merchant_type' => array(
			'label'       => $this->l('Merchant type','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('Select whether your merchant account is C-O-F capable or not. COF enabled merchants can charge Credit cards of clients in background after client enters CC on payment page once.','otppresta'),
			'default'     => 'simple',
			'desc_tip'    => true,
			'options'     => array(
			  "cof_capable"  => $this->l('Card-On-File (COF) capable','otppresta'),
			  "simple"    	 => $this->l('Simple','otppresta')
			)
		),
		
		'rest_api_url' => array(
				'label' => $this->l('COF service URL','otppresta'),
				'type' 			=> 'text',
				'desc' => $this->l('Url of service executing COF transactions using HostedDataID. (Provided by OTP).','otppresta'),
				'default' => 'https://test-cof.ipay.rs/test/cardonfile',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter url','otppresta')
		),
		
		'rest_api_username' => array(
				'label' => $this->l('COF account username','otppresta'),
				'type' 			=> 'text',
				'desc' => $this->l('Username to access service executing COF transactions using HostedDataID. (Provided by OTP).','otppresta'),
				'default' => '',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter username','otppresta')
		),
		
		'rest_api_password' => array(
				'label' => $this->l('COF account password','otppresta'),
				'type' 			=> 'password',
				'desc' => $this->l('Password to access service executing COF transactions using HostedDataID. (Provided by OTP).','otppresta'),
				'default' => '',
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter password','otppresta')
		),
		
		'title' => array(
				'label' => $this->l('Title','otppresta'),
				'type' 			=> 'text',
				'desc' => $this->l('This controls the title which the user sees during checkout.','otppresta'),
				'default' => $this->l('Credit Card payments over OTP','otppresta'),
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter title','otppresta')
		),
		
		'desc'  => array(
				'label'        => $this->l('Description:','otppresta'),
				'type'         => 'textarea',
				'desc'  => $this->l('This controls the description which the user sees during checkout.','otppresta'),
				'default'      => $this->l('Pay securely by Credit or Debit Card via OTP BANKA','otppresta'),
				'desc_tip'     => true,
				'placeholder'	=> $this->l('enter payment method description','otppresta')
		),
		
		'payment_currency' => array(
			'label'       => $this->l('Convert to payment currency','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('If you use currencies that can not be accepted by the OTP you can select currency to convert the amount to before making a payment request.','otppresta'),
			'default'     => 'RSD',
			'desc_tip'    => true,
			'options'     => array(
				"CHF" => 'CHF',
				"GBP" => 'GBP',
				"USD" => 'USD',
				"RSD" => 'RSD',
				"EUR" => 'EUR'
			)
		),
		
		'conversion_rate_adjust' => array(
				'label' => $this->l('Increase conversion rate by %','otppresta') . "(EURRSD:".$this->getExchangeRate("EUR", "RSD").")",
				'type' => 'text',
				'desc' => $this->l('If `Convert currency` is set to an other value than `Do not convert` you can additionally adjust exchange rate here.'),
				'default' => '0.00',
				'desc_tip' => true,
				'placeholder'	=> $this->l('enter adjust in %','otppresta')
		),
		
		
		
		
		
		// 'mode' => array(
			// 'label'       => $this->l('Pay mode'),
			// 'type'        => 'select',
			// 'class'       => 'wc-enhanced-select',
			// 'desc' => $this->l('Select pay mode.'),
			// 'default'     => 'payonly',
			// 'desc_tip'    => true,
			// 'options'     => array(
				// 'fullpay' => $this->l('Full pay'),
				// 'payonly' => $this->l('Pay only'), 
				// 'payplus' => $this->l('Pay plus')
			// )
		// ),
							
		
		
		'allow_hosteddataid' => array(
				'label' => $this->l('Save Credit Card data on provider servers(required for COF operations)','otppresta'),
				'type' => 'select',
				'class'       => 'wc-enhanced-select',
				'desc' => $this->l('This is required for COF background charges. For simple merchants it will save CC info for clients','otppresta'),
				'default' => 'ask',
				'desc_tip'    => true,
				'options'     => array(
					'no'      => $this->l('Do not use this','otppresta'),
					'ask'     => $this->l('Ask user to agreed','otppresta'), 
					'enabled' => $this->l('Enable without asking','otppresta')
				)
		),
		
		'disclaimer' => array(
				'label' => $this->l('Disclaimer message','otppresta'),
				'type' 			=> 'textarea',
				'desc' => $this->l('Disclaimer message','otppresta'),
				'default' => '',
				'desc_tip'      => true,
				'placeholder'	=> ''
		),
		
		'sale_completed' => array(
			'label'       => $this->l('Order status for successful sale','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('Select status order on successful sale.','otppresta'),
			'default'     => Configuration::get('PS_OS_PAYMENT'),
			'desc_tip'    => true,
			'options'     => $this->statuses
		),
		
		'pre_authorization_completed' => array(
			'label'       => $this->l('Order status for successful pre-authorization ','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('Select status order on successful pre-authorization.','otppresta'),
			'default'     => Configuration::get('PS_OS_PAYMENT'),
			'desc_tip'    => true,
			'options'     => $this->statuses
		),
		
		'void_completed' => array(
			'label'       => $this->l('Order status for successful VOID transaction ','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('Select status order on successful VOID transaction.','otppresta'),
			'default'     => Configuration::get('PS_OS_CANCELED'),
			'desc_tip'    => true,
			'options'     => $this->statuses
		),
		
		'payment_failed' => array(
			'label'       => $this->l('Order status for failed payment','otppresta'),
			'type'        => 'select',
			'class'       => 'wc-enhanced-select',
			'desc' => $this->l('Select status order on failed payment','otppresta'),
			'default'     => Configuration::get('PS_OS_ERROR'),
			'desc_tip'    => true,
			'options'     => $this->statuses
		),
		
		'test_ips' => array(
				'label'         => $this->l('Show this payment method to the clients with following IP-s (for testing by the site administrator/tech support)','otppresta'),
				'type' 			=> 'text',
				'desc'	        => $this->l('Enter comma separated list of client IP addresses to this plugin to. All others will not see it.','otppresta'),
				'default' 		=> $this->l(''),
				'desc_tip'      => true,
				'placeholder'	=> $this->l('enter comma separted IPs')
		)
		
	);
	
	foreach($this->_form_fields as $name => $def){
		$this->_form_fields[$name]["name"] = "otppresta_{$name}";
		
		if(isset($def["options"])){
			$tmp = array();
			foreach($def["options"] as $key => $oname ){
				$tmp[] = array(
					"id"    => $key,
					"label" => $oname
				);
			}
			
			$this->_form_fields[$name]["options"] = array(
					'query' => $tmp,
					'id' 	=> 'id',
					'name'  => 'label'
				);
		}
		
		if(!Configuration::hasKey("otppresta_{$name}")){
			if(isset($def["default"])){
				Configuration::updateValue("otppresta_{$name}", $def["default"]);
				
			}else
				Configuration::updateValue("otppresta_{$name}", "");
		}
	}
				