/**
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*/

if(!window.__otppresta_be__){
	window.__otppresta_be__ = true;

	$(document).on("change","#otppresta_merchant_type",function(e){
		if($(this).val() == "cof_capable"){
			$("#otppresta_rest_api_url").closest(".form-group").show();
			$("#otppresta_rest_api_username").closest(".form-group").show();
			$("#otppresta_rest_api_password").closest(".form-group").show();
		}else{
			$("#otppresta_rest_api_url").closest(".form-group").hide();
			$("#otppresta_rest_api_username").closest(".form-group").hide();
			$("#otppresta_rest_api_password").closest(".form-group").hide();
		}
	});

	$(document).on("change keyup","#otppresta_user_sid",function(e){
		if(!window.user_store_sid_different){
			$("#otppresta_store_sid").val($(this).val());
		}
	});

	$(document).on("change","#otppresta_user_store_sid_different",function(e){
		window.user_store_sid_different = $(this).val() == "yes";
		if(!window.user_store_sid_different){
			$("#otppresta_store_sid").val($("#otppresta_user_sid").val());
			$("#otppresta_store_sid").prop("readonly",true);
		}else{
			$("#otppresta_store_sid").prop("readonly",false);
		}
	});

	$(document).ready(function(){
		window.user_store_sid_different = $("#otppresta_user_store_sid_different").val() == "yes";
		
		if(!window.user_store_sid_different){
			$("#otppresta_store_sid").prop("readonly",true);
		}else{
			$("#otppresta_store_sid").prop("readonly",false);
		}
		
		$("#otppresta_merchant_type").trigger("change");
	});
}